	function [L, C, W0, K] = POLISH_LC(Attideal, omegaP, Norder, winv, L, C, K, Rs, RL, const)
	
	% 	Polishes the element values in a lowpass ladder filter with finite zeros
	%	of type a, b or c.
	%
	%	This part is not activated since it is not needed in most cases.
	%	We rely on the computational power of MATLAB and use
	%	an unintelligent random walk approach.
	%
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	%	Author: 		Lars Wanhammar 2007-08-26
    %	Copyright:		by authors - not released for commercial use					
	%	Modified by: 	LW 2014-04-19 
	%	Version: 		1	
	%	Known bugs:		 
	%	Report bugs to:	Wanhammar@gmail.com
	
	TempCost0 = 10^6; L0 = L; C0 = C;
	k = 10^-9;	% May have to be changed to improve the convergence
	for nn = 1:200	% May have to be changed to improve the convergence
		if mod(nn,50) == 1	% May have to be changed to improve the convergence
			k = k/2; 
		end	
		L = L0 + k*(rand(1,length(K))-0.5);	
		if K(Norder) == 9
			L(Norder) = 0;	% The last series inductor is zero for case B and C
		end
		for m = 2:2:Norder
			if m == Norder
				C(m) = C(m) + k*(rand-0.5);
			else
				C(m) = winv(m/2)/L(m);
			end
		end
		H = LADDER_2_H(length(K), [], L, C, Rs, RL, K, omegaP, 1);
		Att = H_2_ATT(const*H);
		TempCost = sum(abs(Att-Attideal));
		if TempCost < TempCost0
			L0 = L; C0 = C; 
			nn
			TempCost0 = TempCost  	% Print progress
			if TempCost0 < 10^-7	% May be adjusted for accuracy
				break; 
			end
		end
	end
	L = L0;
	C = C0;
	winv(winv == 0) = [];
	W0 = 1./sqrt(winv);
